#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/*  :   ,   stdout   */


#define DEFPORT 12345
#define BUFSIZE 128

int main(int argc, char **argv) {
    int my_sock;
    struct sockaddr_in serv_addr;
    struct hostent *he;
    unsigned short portnum = DEFPORT;
    socklen_t len;
    char server_reply[BUFSIZE];
    
    printf("\nStarting Simple Client...\nUsage: %s [host [portnum]]\n\n", argv[0]);
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = htonl(INADDR_LOOPBACK);
    //  . 
    if (argc > 1) {
	he = gethostbyname(argv[1]);
	if (!he) {
	    herror(argv[1]);
	    exit(EXIT_FAILURE);
	}
	if (he->h_addrtype != AF_INET) {
	    fprintf(stderr,"\nunsupported address family %d\n", he->h_addrtype);
	    exit(EXIT_FAILURE);
	}
	//  hostent IP-
	memcpy(&serv_addr.sin_addr.s_addr, he->h_addr_list[0], he->h_length);
    }
    if (argc > 2) {
	if (sscanf(argv[2], "%hd", &portnum) != 1) portnum = DEFPORT;
    }
    serv_addr.sin_port = htons(portnum);
    // 
    my_sock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (my_sock < 0) {
	perror("socket() failed");
	exit(EXIT_FAILURE);
    }
    printf("Trying to connect %s:%d...\n",
	inet_ntoa(serv_addr.sin_addr),
	portnum);
    //   (   )
    if (connect(my_sock, (struct sockaddr*) &serv_addr, sizeof(serv_addr))) {
	perror("connect() failed");
	exit(EXIT_FAILURE);
    }
    // ""   (   )
    do {
	memset(server_reply, 0, BUFSIZE);
	len = read(my_sock, server_reply, BUFSIZE);
	if (len < 0) {
	    perror("read() failed");
	    exit(EXIT_FAILURE);
	}
	write(STDOUT_FILENO, server_reply, len);
    } while (len == BUFSIZE);
    fflush(stdout);
    // 
    shutdown(my_sock, SHUT_RDWR);
    close(my_sock);
    return EXIT_SUCCESS;
}
