#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <sys/poll.h>

/*  :   ,   
  stdout,    "Hello!".
  -   poll() */

#define DEFPORT 12345
#define SPARESLOTS 128
#define BUFSIZE 256

char server_reply[] = "Hello!";
struct pollfd *fds;
int countfds = 0;

void accept_client(int);
void client_action(int); 

int main(int argc, char **argv) {
    int master_sock;
    struct sockaddr_in master_addr;
    unsigned short portnum = DEFPORT;
    
    //    
    fds = malloc(SPARESLOTS*sizeof(struct pollfd));
    if (!fds) {
	perror("malloc() failed");
	exit(EXIT_FAILURE);
    }
    
    printf("\nStarting Simple Server...\nUsage: %s [portnum]\n\n", argv[0]);
    //  . 
    if (argc > 1) {
	if (sscanf(argv[1], "%hd", &portnum)!=1) portnum = DEFPORT;
    }
    // 
    master_sock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (master_sock < 0) {
	perror("socket() failed");
	exit(EXIT_FAILURE);
    }
    //  
    master_addr.sin_family = AF_INET;
    master_addr.sin_port = htons(portnum);
    master_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    if (bind(master_sock, (struct sockaddr*) &master_addr, sizeof(master_addr))) {
	perror("bind() failed");
	exit(EXIT_FAILURE);
    }
    //  
    if (listen(master_sock, SOMAXCONN)) {
	perror("listen() failed");
	exit(EXIT_FAILURE);
    }
    printf("Listening port %d for incoming connections...\n", portnum);
    //   poll -    master_sock
    countfds++;
    fds[0].fd = master_sock;
    fds[0].events = POLLIN;
    fds[0].revents = 0;
    
    while (1) {
	int n;
	n = poll(fds, countfds, -1);
	if (n < 0 && errno != EINTR) {
	    perror("poll() failed");
	    exit(EXIT_FAILURE);
	}
	if (n > 0) {
	    int i;
	    //  ?
	    if (fds[0].revents&POLLIN) accept_client(master_sock);
	    for (i = 1; i < countfds; i++) {
		if (fds[i].revents&POLLIN) client_action(i);
	    }
	}
    }
}

//  
void accept_client(int msock) {
    int client_sock;
    struct sockaddr_in client_addr;
    socklen_t len;
    len = sizeof(client_addr);
    client_sock = accept(msock, (struct sockaddr*) &client_addr, &len);
    if (client_sock < 0) {
	perror("accept() failed");
	exit(EXIT_FAILURE);
    }
    printf("\nConnected client - %s:%u\n",
	inet_ntoa(client_addr.sin_addr),
	ntohs(client_addr.sin_port));
    if (countfds%SPARESLOTS == 0) {
	fds = realloc(fds, (countfds+SPARESLOTS)*sizeof(struct pollfd));
	if (!fds) {
	    perror("realloc() failed");
	    exit(EXIT_FAILURE);
	}
    }
    fds[countfds].fd = client_sock;
    fds[countfds].events = POLLIN;
    fds[countfds].revents = 0;
    countfds++;
    if (fcntl(client_sock, F_SETFL, O_NONBLOCK)) {
	perror("failed to set non-blocking mode");
    }
}

// 
void client_action(int idx) {
    char buf[BUFSIZE];
    int len;
    printf("\nReceived client request:\n");
    do {
	len = read(fds[idx].fd, buf, BUFSIZE);
	if (len>0) write(STDOUT_FILENO, buf, len);
    } while (len == BUFSIZE);
    fflush(stdout);
    write(fds[idx].fd, server_reply, sizeof(server_reply));
    close(fds[idx].fd);
    if (idx < countfds-1) {
        memmove(fds+idx, fds+idx+1, (countfds-idx)*sizeof(struct pollfd));
    }
    countfds--;
}
