#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

/*  :       "Hello!".
    . */

#define DEFPORT 12345

int main(int argc, char **argv) {
    int master_sock, client_sock;
    struct sockaddr_in master_addr, client_addr;
    unsigned short portnum = DEFPORT;
    socklen_t len;
    char server_reply[] = "Hello!";
    
    printf("\nStarting Simple Server...\nUsage: %s [portnum]\n\n", argv[0]);
    //  . 
    if (argc > 1) {
	if (sscanf(argv[1], "%hd", &portnum)!=1) portnum = DEFPORT;
    }
    // 
    master_sock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (master_sock < 0) {
	perror("socket() failed");
	exit(EXIT_FAILURE);
    }
    //  
    master_addr.sin_family = AF_INET;
    master_addr.sin_port = htons(portnum);
    master_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    if (bind(master_sock, (struct sockaddr*) &master_addr, sizeof(master_addr))) {
	perror("bind() failed");
	exit(EXIT_FAILURE);
    }
    //  
    if (listen(master_sock, SOMAXCONN)) {
	perror("listen() failed");
	exit(EXIT_FAILURE);
    }
    printf("Listening port %d for incoming connections...\n", portnum);
    //  (  )
    len = sizeof(client_addr);
    client_sock = accept(master_sock, (struct sockaddr*) &client_addr, &len);
    if (client_sock < 0) {
	perror("accept() failed");
	exit(EXIT_FAILURE);
    }
    printf("Connected client - %s:%u\n\n",
	inet_ntoa(client_addr.sin_addr),
	ntohs(client_addr.sin_port));
    //       1  -  
    shutdown(master_sock, 2);
    close(master_sock);
    //  ""     
    write(client_sock, server_reply, sizeof(server_reply));
    shutdown(client_sock, 2);
    close(client_sock);
    return EXIT_SUCCESS;
}
