
/*
	see comments.txt
*/

#define _GNU_SOURCE

#include <signal.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <netdb.h>
#include <errno.h>

int listener, ns;

#define TCP_PORT 22222

//#define IO_SIGNAL (SIGRTMIN + 7)

#define IO_SIGNAL (SIGRTMIN)

//#define IO_SIGNAL (SIGRTMAX)
//#define IO_SIGNAL SIGPOLL

void setup_sock(int sock)
{
	int res;
	int flags;
	
	flags = fcntl(sock, F_GETFL);
	flags |= (O_ASYNC | O_NONBLOCK);
	
	res = fcntl(sock, F_SETFL, flags);
	if ( res == -1 ){
		perror("fcntl/F_SETFL");
		exit(1);
	};
	
	res = fcntl(sock, F_SETSIG, IO_SIGNAL);
	if ( res == -1 ){
		perror("fcntl/F_SETSIG");
		exit(1);
	};
	
	res = fcntl(sock, F_SETOWN, getpid());
	if ( res == -1  ) {
		perror("fcntl/F_SETOWN");
		exit(1);
	};	 
}

void serv_query(int sock)
{
	int r;
	unsigned int buf;
	int loops = 0;

	while (1) {
	
		loops++;
		r = read(sock, &buf, sizeof(buf));
		if ( -1 == r ) {
			// perror("read()");
			break;
		};
		if ( 0 == r ) {
			// printf("*** CLIENT GONE ***\n");
			close(sock);
			break;
		};
	
		printf("%d bytes read/(%d)\n", r, buf);
		r = write(sock, &buf, sizeof(buf));
		if ( -1 == r ) {
			perror("write()");
			break;
		};
		printf("echo sent\n");
	};
	
	printf("loops = %d\n", loops);
}

/*
 si_code values for SIGPOLL:

 1 - POLL_IN
 2 - POLL_OUT
 3 - POLL_MSG
 4 - POLL_ERR
 5 - POLL_PRI
 6 - POLL_HUP
*/

char * codes[] = { "NOTHING", 
			"POLL_IN",
			"POLL_OUT",
			"POLL_MSG",
			"POLL_ERR",
			"POLL_PRI",
			"POLL_HUP"
};

void io_handler(siginfo_t* sinfo)
{
	struct sockaddr_in clnt_addr;
	int fd, addrlen;
//	int nb;

	printf("<--- SIGNAL --->\n");
	printf("sinfo->si_signo = %d\n", sinfo->si_signo);
	printf("sinfo->si_code = %d (%s)\n", sinfo->si_code, codes[sinfo->si_code]);
	printf("sinfo->si_fd = %d\n", sinfo->si_fd);
	// printf("sinfo->si_band = %ld\n", sinfo->si_band);

	fd = sinfo->si_fd;
	
	switch ( sinfo->si_code ) {
	
case POLL_IN:

	if (fd == listener) {

		printf("new connection...");
		memset(&clnt_addr, 0, sizeof(clnt_addr));
		addrlen = sizeof(clnt_addr);
		ns = accept(listener, &clnt_addr, &addrlen);
		
		if ( ns == -1 ) {
			perror("accept()");
			exit(1);
		};
		setup_sock(ns);
		printf("accepted\n");
		
		printf(" <o> Right after accept() ... \n");
		serv_query(ns);
		
	} else { 
		printf("<o> on signal ...\n");
		serv_query(fd);
	};
break;

case POLL_OUT:
	;;;
break;

case POLL_MSG:
case POLL_PRI:
case POLL_ERR:
case POLL_HUP:
	close(fd);
break;

default:
	printf("unknown event type\n");
	};
}

int res;
struct sockaddr_in serv_addr;
struct sigaction io_action;
sigset_t blocked;
int yes = 1;
siginfo_t sinfo;

int main(int argc, char *argv[])
{
	printf("SIGRTMIN = %d, IO_SIGNAL = %d\n", SIGRTMIN, IO_SIGNAL);
	listener = socket(AF_INET, SOCK_STREAM, 0);
	if ( -1 == listener ) {
		perror("socket()");
		exit(1);
	};
	printf("listener socket = %d\n", listener);

	res = setsockopt(listener, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof(int));
	if ( res == -1 ) {	
		perror("setsockopt()");
		exit(1);
	};

	memset(&serv_addr, 0, sizeof(serv_addr));
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = INADDR_ANY;
	serv_addr.sin_port = htons(TCP_PORT);

	res = bind(listener, &serv_addr, sizeof(serv_addr));
	if ( -1 == res ) {
		perror("bind()");
		exit(1);
	};
	res = listen(listener, 16);
	if ( -1 == res ) {
		perror("listen()");
		exit(1);
	};
	setup_sock(listener);
	
	sigemptyset(&blocked);
	sigaddset(&blocked, IO_SIGNAL);
//	sigaddset(&blocked, SIGIO);
	sigprocmask(SIG_BLOCK, &blocked, 0);
	
	while (1) {

		res = sigwaitinfo(&blocked, &sinfo);
		if (res == -1) {
			perror("sigwaitinfo()");
			continue;
			//break;
		};
		
		if ( res == IO_SIGNAL )
			io_handler(&sinfo);
		
		/*
		if ( res == SIGIO ) // ?????????
			// handle rt-sig queue overflow ???
			break;
			;;;
		*/
	};
		
	exit(1);
}
