
/*
*/

#define _GNU_SOURCE

#include <signal.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <string.h>

#include <sys/poll.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <netdb.h>
#include <errno.h>

int listener, ns;

#define TCP_PORT 22222

#define IO_SIGNAL SIGRTMIN
#define RTSIG_QUEUE_OVERFLOW_SIGNAL SIGIO

#define MAX_CLIENTS 10
struct pollfd socks[MAX_CLIENTS];
int last_sock;

void setup_sock(int sock)
{
	int res;
	int flags;
	
	flags = fcntl(sock, F_GETFL);
	flags |= (O_ASYNC | O_NONBLOCK);
	
	res = fcntl(sock, F_SETFL, flags);
	if ( res == -1 ){
		perror("fcntl/F_SETFL");
		exit(1);
	};
	
	res = fcntl(sock, F_SETSIG, IO_SIGNAL);
	if ( res == -1 ){
		perror("fcntl/F_SETSIG");
		exit(1);
	};
	
	res = fcntl(sock, F_SETOWN, getpid());
	if ( res == -1  ) {
		perror("fcntl/F_SETOWN");
		exit(1);
	};	 
}


int add_sock(s)
{
	if ( s >= MAX_CLIENTS )
		return 0; 
	socks[s].fd = s;
	if ( s > last_sock)
		last_sock = s;
	return 1;
}

int rem_sock(s)
{
	if ( s >= MAX_CLIENTS)
		return 0;

	socks[s].fd = -1;
	
	if ( s == last_sock) {
		while ( socks[last_sock].fd == -1)
			last_sock--;
	};
	return 1;
}

void serv_query(int sock)
{
	int r;
	unsigned int buf;
	int loops = 0;

	while (1) {
	
		loops++;
		r = read(sock, &buf, sizeof(buf));
		if ( -1 == r ) {
			// perror("read()");
			break;
		};
		if ( 0 == r ) {
			// printf("*** CLIENT GONE ***\n");
			rem_sock(sock);
			close(sock);
			break;
		};
	
		printf("%d bytes read/(%d)\n", r, buf);
		r = write(sock, &buf, sizeof(buf));
		if ( -1 == r ) {
			perror("write()");
			break;
		};
		printf("echo sent\n");
	};
	
	printf("loops = %d\n", loops);
}

void poll_socks()
{
	int r;
	int s;
	struct sockaddr_in clnt_addr;
	int addrlen;

	for (;;) {
		r = poll(&socks[3], last_sock-listener+1, 10000);
//		r = poll(&socks[listener], MAX_CLIENTS, 1000);
		if ( !r ) // time out
			break;
		if ( -1 == r ) {
			perror("poll");
			exit(1);
		};
		printf("polling... r = %d\n", r);
		for (s = listener; s <= last_sock; s++) {
			if (socks[s].revents & POLLIN) {
				if (s == listener) {
					printf("new connection...");
					memset(&clnt_addr, 0, sizeof(clnt_addr));
					addrlen = sizeof(clnt_addr);
					ns = accept(s, &clnt_addr, &addrlen);
		
					if ( ns == -1 ) {
						perror("accept()");
						exit(1);
					};
					if ( !add_sock(ns) ){
						close(ns);
					} else {
						setup_sock(ns);
						printf("accepted\n");
						printf(" <o> Right after accept() ... \n");
						serv_query(ns);
					};
				} else {
					printf("POLLIN ...\n");
					serv_query(s);
				}
			}
			if (socks[s].revents & POLLOUT) {
			}
			if (socks[s].revents & POLLERR) {
			}
			if (socks[s].revents & POLLHUP) {
			}
		};
	};
}



/*
 si_code values for SIGPOLL:

 1 - POLL_IN
 2 - POLL_OUT
 3 - POLL_MSG
 4 - POLL_ERR
 5 - POLL_PRI
 6 - POLL_HUP
*/

char * codes[] = { "NOTHING", 
			"POLL_IN",
			"POLL_OUT",
			"POLL_MSG",
			"POLL_ERR",
			"POLL_PRI",
			"POLL_HUP"
};

void io_handler(siginfo_t* sinfo)
{
	struct sockaddr_in clnt_addr;
	int fd, addrlen;
//	int nb;

	printf("<--- SIGNAL --->\n");
	printf("sinfo->si_signo = %d\n", sinfo->si_signo);
	printf("sinfo->si_code = %d (%s)\n", sinfo->si_code, codes[sinfo->si_code]);
	printf("sinfo->si_fd = %d\n", sinfo->si_fd);
	// printf("sinfo->si_band = %ld\n", sinfo->si_band);

	fd = sinfo->si_fd;
	
	switch ( sinfo->si_code ) {
	
case POLL_IN:

	if (fd == listener) {

		printf("new connection...");
		memset(&clnt_addr, 0, sizeof(clnt_addr));
		addrlen = sizeof(clnt_addr);
		ns = accept(listener, &clnt_addr, &addrlen);
		
		if ( ns == -1 ) {
			perror("accept()");
			exit(1);
		};
		printf("accepted\n");
		if (!add_sock(ns)) {
			close(ns);
		} else {
			setup_sock(ns);
			printf(" <o> Right after accept() ... \n");
			serv_query(ns);
		};
	} else { 
		printf("<o> on signal ...\n");
		serv_query(fd);
	};
break;

case POLL_OUT:
	;;;
break;

case POLL_MSG:
case POLL_PRI:
case POLL_ERR:
case POLL_HUP:
	close(fd);
break;

default:
	printf("unknown event type\n");
	};
}

int res;
struct sockaddr_in serv_addr;
struct sigaction io_action;
sigset_t blocked;
int yes = 1;
siginfo_t sinfo;
int s;

int main(int argc, char *argv[])
{

	memset(socks, 0, MAX_CLIENTS*sizeof(struct pollfd));
	for ( s = 0; s < MAX_CLIENTS; s++) {
		socks[s].fd = -1;
		socks[s].events = POLLIN;
		socks[s].revents = 0;
	};
	
	printf("SIGRTMIN = %d, IO_SIGNAL = %d\n", SIGRTMIN, IO_SIGNAL);
	listener = socket(AF_INET, SOCK_STREAM, 0);
	if ( -1 == listener ) {
		perror("socket()");
		exit(1);
	};
	printf("listener socket = %d\n", listener);

	res = setsockopt(listener, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof(int));
	if ( res == -1 ) {	
		perror("setsockopt()");
		exit(1);
	};

	memset(&serv_addr, 0, sizeof(serv_addr));
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = INADDR_ANY;
	serv_addr.sin_port = htons(TCP_PORT);

	res = bind(listener, &serv_addr, sizeof(serv_addr));
	if ( -1 == res ) {
		perror("bind()");
		exit(1);
	};
	res = listen(listener, 16);
	if ( -1 == res ) {
		perror("listen()");
		exit(1);
	};
	setup_sock(listener);
	add_sock(listener);

	io_action.sa_handler = SIG_DFL;
//	io_action.sa_sigaction = SIG_DFL;
//	io_action.sa_flags = SA_SIGINFO;
	res = sigaction(IO_SIGNAL, &io_action, NULL);
	if ( res == -1 ) {
		perror("sigaction()");
		exit(1);
	};
	
	for (;;) {

		// flash signal queue
		sigemptyset(&blocked);
		sigprocmask(SIG_BLOCK, &blocked, 0);

		poll_socks();
		
		// now start dequeueing signals normally
		sigaddset(&blocked, IO_SIGNAL);
		sigaddset(&blocked, RTSIG_QUEUE_OVERFLOW_SIGNAL);
		sigprocmask(SIG_BLOCK, &blocked, 0);
	
		for (;;) {

			res = sigwaitinfo(&blocked, &sinfo);
			if (res == -1) {
				perror("sigwaitinfo()");
				continue;
				//break;
			};
		
			if ( res == IO_SIGNAL ) {
				io_handler(&sinfo);
				continue;
			}
		
			// signal queue overflow, break to outer loop
			break;
			
			//if ( res == RTSIG_QUEUE_OVERFLOW_SIGNAL ) { 
			//	printf(" Oops, rt-signal queue overflow ... \n");
			//	break;;;;;;
			//};
		};
	};

	exit(1);
}
