#include <unistd.h>
#include <sys/types.h>
#include <sys/select.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

/*   select()   / */


#define TIMEOUT 20

char clock[] = {'|', '/', '-', '\\'};

int main() {
    fd_set in;
    struct timeval t;
    int cntr = 0;
    int n = 0;
    printf("Waiting for your input:\n");
    for (cntr = 0; cntr < TIMEOUT; cntr++) {
	/*  "" */
	printf("\r%c ", clock[cntr%sizeof(clock)]);
	fflush(stdout);
	
	FD_ZERO(&in);
	FD_SET(STDIN_FILENO, &in);
	t.tv_sec = 1; t.tv_usec = 0; /*  */
	n = select(STDIN_FILENO+1, &in, NULL, NULL, &t);
	if (n < 0 && errno != EINTR) {
	    perror("select() failed");
	    exit(1);
	}
	if (n > 0) break;
    }
    if (n > 0) {
	/*  ģ  */
	char *buff;
	ioctl(STDIN_FILENO, FIONREAD, &n);
	buff = malloc(n+1);
	if (!buff) {
	    perror("malloc() failed");
	    exit(1);
	}
	n = read(STDIN_FILENO, buff, n);
	buff[n] = '\0';
	printf("\n%d byte(s) entered: [%s]\n", n, buff);
	free(buff);
    }
    return 0;
}
