#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <pthread.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>

/*   :
       
   gethostbyname() */

/*     -lpthread */

pthread_t pt;
int idx = 0;

void parent(void);
void* child(void*);

int main() {
    if (pthread_create(&pt, NULL, &child, NULL)) {
	perror("pthread_create() failed\n");
	return 1;
    }
    parent();
    pthread_join(pt, NULL);
    return 0;
}

//parent thread
void parent() {
    struct hostent *he;
    char buf[INET_ADDRSTRLEN] = "";
    while (1) {
        he = gethostbyname("dims.karelia.ru");
        if (!he) {
    	    herror("oops");
	    return;
	}
	inet_ntop(AF_INET, he->h_addr_list[0], buf, INET_ADDRSTRLEN);
	printf("%d [Official name: %s IP: %s]\n", idx++, he->h_name, buf);
    }
}

//child thread
void* child(void* tmp) {
/*    pthread_detach(pthread_self());*/
    struct hostent *he;
    char buf[INET_ADDRSTRLEN] = "";
    while (1) {
        he = gethostbyname("iq.karelia.ru");
        if (!he) {
    	    herror("oops");
	    return NULL;
	}
	inet_ntop(AF_INET, he->h_addr_list[0], buf, INET_ADDRSTRLEN);
	printf("%d {Official name: %s IP: %s}\n", idx++, he->h_name, buf);
    }
}
